<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Application extends Model 
{

    protected $table = 'applications';
    public $timestamps = true;
    protected $fillable = array('profile_id', 'job_id', 'status', 'cover_later', 'resume_path');

    public function profile()
    {
        return $this->hasOne('App\Models\Profile');
    }

    public function job()
    {
        return $this->hasOne('App\Models\Job');
    }

    public function status()
    {
        return $this->belongsToMany('App\Model\ApplicationStatusHistory');
    }

}